/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8285.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8285.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8285.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8285.DeviceView.ModuleLike;
import ibm.nways.ras.RAS;
import ibm.nways.widgets.WidgetCookie;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Module
implements ModuleLike {
    protected int numberOfPorts;
    protected int numberOfBridgePorts;
    protected int numberOfSlots;
    protected String backgroundGif = "";
    protected int growthDirection;
    protected int modType;
    protected Point location;
    protected int slot;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer moduleContainer = new GraphicContainer();
    private Vector components = new Vector();
    protected String destinationPanel;
    protected boolean hasPorts = false;
    protected ChassisInfoLike chassis;
    public String flyoverKey = "";
    public Object[] flyoverArgs = new Object[2];
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8285.DeviceView.GraphicResources";
    protected static final String SER_PATH = "ibm.nways.jdm8285.WCDefault";
    protected static final int COOKIE_FLAGS = 28;
    protected static final int COOKIE_FLAGS_FLYOVER = 20;
    protected String description = "";
    protected String cookieID;
    protected GenModel modModel;
    protected GenModel portsModel;
    private String cachedIPAddress;

    public void dispose() {
        this.modModel = null;
        this.portsModel = null;
        this.graphicContainer = null;
        if (this.moduleContainer != null) {
            this.moduleContainer.dispose();
            this.moduleContainer = null;
        }
        this.chassis = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public void draw() {
        WidgetCookie widgetCookie = new WidgetCookie(this.cookieID, BUNDLE_NAME, this.getModelInfo(), SER_PATH, this.getModel(), this.chassis.getBrowser(), 28, this.getDestinationPanel());
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(BUNDLE_NAME, this.flyoverKey, this.flyoverArgs);
        widgetCookie.GetImage().setFlyOver(new GraphicFlyOver(i18NMsgFormat.getTranslation()));
        this.moduleContainer.add((GraphicContainer)widgetCookie);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 6, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 6, this, "draw", exception);
            }
        }
        this.graphicContainer.add(this.moduleContainer);
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public GenModel getModel() {
        return this.modModel;
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.SlotIndex", new Integer(this.slot));
        return modelInfo;
    }

    public String getDestinationPanel() {
        return this.destinationPanel;
    }

    public final void setCommonInformation(ChassisInfoLike chassisInfoLike, int n, GraphicContainer graphicContainer, GenModel genModel) {
        this.chassis = chassisInfoLike;
        this.slot = n;
        this.graphicContainer = graphicContainer;
        try {
            this.modModel = (GenModel)genModel.getComponent("Modules");
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, "setCommonInformation", exception);
        }
        if (this.hasPorts) {
            try {
                this.portsModel = (GenModel)genModel.getComponent("AtmSWInterface");
                return;
            }
            catch (Exception exception) {
                RAS.logException(19, 6, this, "setCommonInformation", exception);
                return;
            }
        }
    }

    public void setSpecificInformation() {
    }

    public void discoverChildren() {
    }

    protected String getDescription() {
        String string = "";
        try {
            GenModel genModel = this.getModel();
            ModelInfo modelInfo = this.getModelInfo();
            modelInfo = genModel.getInfo("Panel", "default", modelInfo);
            Serializable serializable = modelInfo.get("Panel.ModuleDescription");
            if (serializable instanceof OctetString) {
                string = ((OctetString)serializable).toDisplayString();
            } else if (serializable instanceof String) {
                string = serializable.toString();
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 6, this, "getDescription", exception);
        }
        int n = string.indexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String getIPAddress() {
        GenModel genModel = null;
        Object object = null;
        if (this.cachedIPAddress == null) {
            try {
                genModel = (GenModel)((GenModel)this.chassis.getBrowser().getModel()).getComponent("Agents");
                ModelInfo modelInfo = new ModelInfo();
                modelInfo.add("Index.AgentsSlotIndex", new Integer(this.slot));
                ModelInfo modelInfo2 = genModel.getInfo("Panel", "default", modelInfo);
                object = modelInfo2.get("Panel.AgentsIpAddress");
            }
            catch (Exception exception) {
                RAS.logException(19, 6, this, "getIPAddress", exception);
            }
            this.cachedIPAddress = object instanceof IPAddress ? object.toString() : "0.0.0.0";
        }
        return this.cachedIPAddress;
    }

    public final int getGrowthDirection() {
        return this.growthDirection;
    }

    public final int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.moduleContainer.setLocation(this.location.x, this.location.y);
    }
}

